//// *********************************** ////
//// State of California master template ////
////             Version 1.20            ////
////       Last Updated 03/23/2007       ////
////                                     ////
//// Add your own Department-specific    ////
//// scripts here.                       ////
//// *********************************** ////

// selectSearch - If you are not using DTS site search you may delete lines 10-to-25
// Choose between the statewide search and your own local site search.

function selectSearch() { 
	if (document.getElementById("control").which[0].checked) {
	  document.getElementById("ca_form").q.value = document.getElementById("search").value;
	  document.getElementById("ca_form").submit();
	} else {
		// Change the 'q' to the parameter your search engine uses for its text field
	  document.getElementById("local_form").q.value = document.getElementById("search").value;
	  document.getElementById("local_form").submit();
	}
  return false;
}

// End of selectSearch javascript

// breadcrumbs
// This function populates the breadcrumb section of the page.

function breadcrumbs()
{
	if ((document.getElementById) && document.getElementById('breadcrumb_dynamic')) { // Make sure browser supports getElementById and breadcrumb_dynamic exists
		var wrkLocation = location.href;
		
		// Check to see if URL is from a Regional Site and identify the given region
		var regionName = "";
		if(wrkLocation.indexOf('/northcoast') > 0) regionName = "northcoast";
		if(wrkLocation.indexOf('/centralcoast') > 0) regionName = "centralcoast";
		if(wrkLocation.indexOf('/centralvalley') > 0) regionName = "centralvalley";
		if(wrkLocation.indexOf('/lahontan') > 0) regionName = "lahontan";
		if(wrkLocation.indexOf('/sanfranciscobay') > 0) regionName = "sanfranciscobay";
		if(wrkLocation.indexOf('/losangeles') > 0) regionName = "losangeles";
		if(wrkLocation.indexOf('/coloradoriver') > 0) regionName = "coloradoriver";
		if(wrkLocation.indexOf('/santaana') > 0) regionName = "santaana";
		if(wrkLocation.indexOf('/sandiego') > 0) regionName = "sandiego";
		if(wrkLocation.indexOf('/monitoringcouncil') > 0) regionName = "monitoringcouncil";
		
		var wrkLength = wrkLocation.indexOf("#");  // Find the begining of any anchor reference
		if(wrkLength != -1){
			var wrkLocation = wrkLocation.substr(0,wrkLength);  // Extract the anchor reference
		}	
		var wrkLength = wrkLocation.indexOf("?");  // Find the begining of the query string
		if(wrkLength != -1){
			var wrkLocation = wrkLocation.substr(0,wrkLength);  // Extract the query string
		}	
 
		var arrURL=wrkLocation.split("/"); // Array containing the current location, split at the slashes
		
		var output='<a href="/">Home</a>'; // The string which will be output to the browser, starts with a link to the home page
				
		var path = ''; // Link for the crumbs

		// If last item is blank or index.* or default.*, remove it
		//if (arrURL[arrURL.length-1] == '' || arrURL[arrURL.length-1].match(/^index\.|^default\./i) ) {		//Condition changed per Shelley's request. Do not display file name in breadcrumbs.
		//
		if (arrURL[arrURL.length-1] == '' || arrURL[arrURL.length-1].match(/^.*?\./i) ) {
			arrURL.length--;
			//arrURL[arrURL.length-1] = '';
		}

		if (arrURL.length > 3) {
			for (counter = 3;counter <= arrURL.length-1;counter++) {  // Loop to display the links
				if(path.length == 0){  // always start links with '/' 
					path = '/';
				}
				path += arrURL[counter] + '/';  // always end links to folder with '/' 
				output += ' <img src="/images/ca_department/bullet_blue.gif" alt="" /> <a href="' + path + '">' + capitalize(arrURL[counter].replace(/_/g,' ')) + '</a>';
			}

			// Display the name of the current page in bold
			//output += ' <img src="/images/ca_department/bullet_blue.gif" alt="" /> <strong>' + capitalize(arrURL[arrURL.length-1].replace(/_/g,' ').replace(/\.\w{3,5}$/,'')) + '</strong>';
		}
		
		// If URL is from a Regional Site and remove "Home" link and change Regional Site link name to "Home".
		if(regionName.length > 0) {
			output = output.replace('<a href="/">Home</a> <img src="/images/ca_department/bullet_blue.gif" alt="" /> ','');
			var strFind = '<a href="/' + regionName + '/">' + capitalize(regionName) + '</a>';
			var strReplace = '<a href="/' + regionName + '/">Home</a>';
			output = output.replace(strFind,strReplace);
		}
		
		document.getElementById('breadcrumb_dynamic').innerHTML = output;  // Display the breadcrumbs
	}
}

// This function capitalizes any given string. Use to capitalize breadcrumbs accordingly
function capitalize(inputString) {
	var tmpStr, tmpChar, preString, postString, strlen;
	tmpStr = inputString.toLowerCase();
	stringLen = tmpStr.length;
	if (stringLen > 0) 
	{
		for (i = 0; i < stringLen; i++)
		{
			if (i == 0)
			{
				tmpChar = tmpStr.substring(0,1).toUpperCase();
				postString = tmpStr.substring(1,stringLen);
				tmpStr = tmpChar + postString;
			} else {
				tmpChar = tmpStr.substring(i,i+1);
				if (tmpChar == " " && i < (stringLen-1))
				{
					tmpChar = tmpStr.substring(i+1,i+2).toUpperCase();
					preString = tmpStr.substring(0,i+1);
					postString = tmpStr.substring(i+2,stringLen);
					tmpStr = preString + tmpChar + postString;
				}
			}
		}
	}
	return tmpStr;
}


addLoadEvent(breadcrumbs);  // Add breadcrumbs to the page onload event handler

// End of breadcrumbs javascript

// NOTES: Add this code to the end of root:\javascript\depatrment.js



/********************************************************
	This function will hide the breadcrumbs as needed.
	You may call this function in your SHTML page. Just
	add the following example to the javascript area 
	that precedes the content area. 
	
	EXAMPLE:	addLoadEvent(hidebreadcrumbs);
*********************************************************/	
function hidebreadcrumbs() {
	document.getElementById('breadcrumb_dynamic').style.display = 'none';
}


/********************************************************
	This function will hide the search box as needed.
	You may call this function in your SHTML page. Just
	add the following example to the javascript area 
	that precedes the content area. 
	
	EXAMPLE:	addLoadEvent(hidesearchbox);
*********************************************************/	
function hidesearchbox() {
	document.getElementById('search_and_skipto').style.display = 'none';
}


/********************************************************
	This function will hide the main navigation tab 
	menu box as needed. You may call this function in 
	your SHTML page. Just add the following example to 
	the javascript area that precedes the content area. 
	
	EXAMPLE:	addLoadEvent(hidenavigation);
*********************************************************/	
function hidenavigation() {
	document.getElementById('navigation').style.display = 'none';
}


/********************************************************
	This function will hide the page footer as needed. 
	You may call this function in your SHTML page. Just 
	add the following example to the javascript area 
	that precedes the content area. 
	
	EXAMPLE:	addLoadEvent(hidefooter);
*********************************************************/	
function hidefooter() {
	document.getElementById('footer').style.display = 'none';
}


/********************************************************
	This function will hide the left nav bar as needed. 
	You may call this function in your SHTML page. Just 
	add the following example to the javascript area 
	that precedes the content area. 
	
	EXAMPLE:	addLoadEvent(hideleftnav);
*********************************************************/	
function hideleftnav() {
	document.getElementById('left_column').style.display = 'none';
	document.getElementById('left_column').style.display = 'none';
	document.getElementById('middle_column').style.margin = '0';
	document.getElementById('middle_column').style.margin = '0 0 0 10px';
	document.getElementById('main_content_1').style.background = 'none';
}



/********************************************************
	This function will show the browser download links 
	at the top of the screen if the client browser is 
	other than IE7 or Mozilla Firefox 3.0
	
	The links are found is the global_header.inc file 
	in the state site root templates. this inc file is 
	applied across the entire waterboards web presence.
*********************************************************/	
function CheckBrowserVersion() {
	var ShowDownload = true;
	var BrowserName = ' '+navigator.appName;
	var BrowserVersion = navigator.appVersion;
	
	//If browser is IE or Mozilla
	if(BrowserName.indexOf('Microsoft Internet Explorer',0) > 0 || BrowserName.indexOf('Netscape',0) > 0) {
		if(BrowserVersion.indexOf('MSIE 7',0) > 1 || parseInt(BrowserVersion) >= 5) {
			ShowDownload = false;
		}
	}
	
	document.getElementById('BrowserDownload').style.display = (ShowDownload)? 'inline': 'none';
	//document.getElementById('BrowserDownload').style.width='100%';
}
//addLoadEvent(CheckBrowserVersion);






/////////////////////////
//// tabpanel_module ////
/////////////////////////


//// tabpanel_mouseover
//// This function is called when a tabpanel tab is hovered

function tabpanel_mouseover(node)
{
  var panel_1_width = document.getElementById("tabpanel_1_sublist").offsetWidth; // Needed for IE
  document.getElementById("tabpanel_1").className = ""; // De-activate default item
  node.className = "tabpanel_default"; // Activate the hovered item
  if (panel_1_width) {
    if (document.getElementById("tabpanel_2_sublist"))
      document.getElementById("tabpanel_2_sublist").style.width = (panel_1_width - 2) + "px"; // Needed for IE
    if (document.getElementById("tabpanel_3_sublist"))
      document.getElementById("tabpanel_3_sublist").style.width = (panel_1_width - 2) + "px"; // Needed for IE
    if (document.getElementById("tabpanel_4_sublist"))
      document.getElementById("tabpanel_4_sublist").style.width = (panel_1_width - 2) + "px"; // Needed for IE
    if (document.getElementById("tabpanel_5_sublist"))
      document.getElementById("tabpanel_5_sublist").style.width = (panel_1_width - 2) + "px"; // Needed for IE
  }
}

//// tabpanel_mouseout
//// This function is called on mouseout

function tabpanel_mouseout(node)
{
  node.className = ""; // De-activate this item
  document.getElementById("tabpanel_1").className = "tabpanel_default"; // Activate default item
  
  var panel_1_width = document.getElementById("tabpanel_1_sublist").offsetWidth; // Needed for IE
  document.getElementById("tabpanel_1_sublist").style.width = (panel_1_width - 2) + "px"; // Needed for IE
}

// End of tabpanel_module javascript





// Carousel script

var Carousel = {
	isMouseBtnPressed: 0, // Is the mouse button being pressed?
	currentSpeed: 0, // current carousel speed
	minimumSpeed: 2, // minimum speed
	maximumSpeed: 30, // maximum speed
	hitTheBrakes: 0, // Did the user move the mouse off the arrow?
	scrollThis: null, // the "caro_images2" element
	scrolldelay: null, // timer ID

	// This function updates the position of the "caro_images2" element. It calls itself
	// recursively during movement.
	caroScroll:function (sDirection) {
		var iDirection = (sDirection == "Left") ? 1 : -1; // Left arrow moves in positive direction, right arrow negative

		if (Carousel.isMouseBtnPressed && !Carousel.hitTheBrakes) { // "!Carousel.hitTheBrakes" needed in case user clicks and drags off arrow
			Carousel.currentSpeed += iDirection; // Accelerate
			if (Math.abs(Carousel.currentSpeed) > Carousel.maximumSpeed) // Are we exceeding the speed limit?
				Carousel.currentSpeed = iDirection * Carousel.maximumSpeed; // Set speed to maximum
		} else { // mouseup or mouseout
			Carousel.currentSpeed -= iDirection; // Decelerate
			if (iDirection == 1) { // Left arrow
				if (Carousel.currentSpeed < Carousel.minimumSpeed) { // too slow?
					if (Carousel.hitTheBrakes) { // mouse out?
						Carousel.currentSpeed = 0; // come to a stop
					} else {
						Carousel.currentSpeed = Carousel.minimumSpeed; // set speed to minimum
					}
				}
			} else { // Right arrow
				if (Carousel.currentSpeed > -Carousel.minimumSpeed) { // too slow?
					if (Carousel.hitTheBrakes) { // mouse out?
						Carousel.currentSpeed = 0; // come to a stop
					} else {
						Carousel.currentSpeed = -Carousel.minimumSpeed; // set speed to minimum
					}
				}
			}
		}

		if (iDirection == 1) { // left arrow
			if (parseInt(Carousel.scrollThis.style.left) < 0) { // not at the left edge?
				updatePosition();
			} else { // we're at the left edge
				document.getElementById("caro_left").style.backgroundPosition = '-40px 0px'; // grey left arrow
			}
		} else { // right arrow
			if ( ( document.getElementById("caro_images1").offsetWidth - parseInt(Carousel.scrollThis.style.left) ) < Carousel.scrollThis.offsetWidth ) { // not at the right edge?
				// (width of container) - (position of scroller) < (full width of the content)
				updatePosition();
			} else { // we're at the right edge
				document.getElementById("caro_right").style.backgroundPosition = '-102px 0px'; // grey right arrow
			}
		}

		function updatePosition() {
			document.getElementById("caro_left").style.backgroundPosition = '-9px 0px'; // blue left arrow
			document.getElementById("caro_right").style.backgroundPosition = '-71px 0px'; // blue right arrow
			Carousel.scrollThis.style.left=parseInt(Carousel.scrollThis.style.left) + Carousel.currentSpeed + 'px'; // Update position of scrollThis
			if (Carousel.currentSpeed) {
				clearTimeout(Carousel.scrolldelay); // fix problem where user moves mouse quickly from one arrow to the other
				Carousel.scrolldelay = setTimeout('Carousel.caroScroll("' + sDirection + '")',30); // scrolls every __ milliseconds
			}
		}
	},

	// This function inserts the arrows.  It is called on page load.
	initialize:function () {
		if (document.getElementById && document.getElementById("carousel")) { // Make sure browser supports getElementById and div "carousel" exists

			// Check to see if CSS is enabled
			var elementCaroRight = document.getElementById("caro_images1");
			if (elementCaroRight.currentStyle) { // for IE
				var styleCaroRight = elementCaroRight.currentStyle["position"];
			}
			else if (window.getComputedStyle) { // for FF
				var styleCaroRight = document.defaultView.getComputedStyle(elementCaroRight,null).getPropertyValue("position");
			}
			if (styleCaroRight == "relative") { /* CSS is enabled */

				var filenameArrows = "/images/carousel.png";

				if (/MSIE (\d+\.\d+);/.test(navigator.userAgent)){ // Check for IE
					var ieversion=new Number(RegExp.$1)
					if (ieversion <= 6){
						filenameArrows = "/images/carousel.gif"; // IE6 doesn't support transparent png, so use gif
					}
				}

				Carousel.scrollThis = document.getElementById("caro_images2");
				Carousel.scrollThis.style.left = "0px";

				document.getElementById("caro_images1").style.overflow="hidden"; /* Hide the scrollbars */

				document.getElementById("caro_left").style.background = 'transparent url(' + filenameArrows + ') -40px 0px no-repeat'; // left arrow starts grey
				document.getElementById("caro_left").style.width = '23px';
				document.getElementById("caro_left").style.height = '50px';

				document.getElementById("caro_right").style.background = 'transparent url(' + filenameArrows + ') -71px 0px no-repeat'; // right arrow starts blue
				document.getElementById("caro_right").style.width = '23px';
				document.getElementById("caro_right").style.height = '50px';

			}
		}
	}
}

addLoadEvent(Carousel.initialize);

// -->
